/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSecureString.h,v 1.3 1999/09/23 23:50:54 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSecureString_h	// [
#define Included_CSecureString_h

#include "pgpClassesConfig.h"

#include "CArray.h"
#include "CErrorState.h"
#include "CList.h"

_PGP_BEGIN

// Class CSecureString

class CSecureString SMART_ERROR_INHERIT
{
private:
	struct SecureChar;

public:
	CSecureString() { }
	CSecureString(const char *str);
	CSecureString(const CSecureString& csString);
	~CSecureString();

	CSecureString&	operator=(const char *str)
	{
		Assign(str);
		return *this;
	}

	CSecureString&	operator=(const CSecureString& csString)
	{
		Assign(csString);
		return *this;
	}

	PGPBoolean	operator==(const CSecureString& csString) const;

	PGPBoolean	operator!=(const CSecureString& csString) const
	{
		return !operator==(csString);
	}

	char	operator[](int pos) const {return GetAt(pos);}

	PGPUInt32	Length() const {return mCharList.Count();}

	char		GetAt(PGPInt32 pos) const;
	void		RemoveAt(PGPInt32 pos);
	void		SetAt(PGPInt32 pos, char c);
	SMART_ERROR	InsertAfter(PGPInt32 pos, char c);

	void	Extract(CSecureArray<char>& secureChars) const;
	void	Clear();

	SMART_ERROR	Assign(const char *str);
	SMART_ERROR	Assign(const CSecureString& csString);

private:
	CList<SecureChar>	mCharList;

	SecureChar *	GetSCAtIndex(PGPInt32 index) const;
	PGPByte			MakeNewKey() const;
};

_PGP_END

#endif	// ] Included_CSecureString_h
